\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 16))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Troparul Sfintei Parascheva"
  %subtitle = "Kanon zu 4 Stimmen"
  subsubtitle = " "
  %poet = "Sigmund von Birken 1663"
  composer = \markup \center-column { "Nicolae Lungu" \small 
  "după I. Popescu-Pasărea" }
  %arranger =  "Böhmische Brüder 1501/1531"
  %meter = "Andante"
  tagline = ""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  %\cadenzaOn
  \time 4/4
  %\partial 4
  %\override Staff.TimeSignature #'stencil = ##f
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}


textOne = \lyrics {
  În -- tru ti -- ne, Mai -- că, cu o -- sâr -- di -- e 
  s-a mân -- ­tu -- it cel du -- pă chip, 
  că lu -- ând Cru -- cea, ai ur -- mat lui Hris -- tos 
  și lu -- crând ai în -- ­vă -- ­țat să nu se ui -- te 
  la trup, căci es -- te tre -- că -- tor, ci să poar -- te 
  gri -- jă de su -- flet, de lu -- crul cel ne -- ­mu -- ri -- tor.
  Pen -- tru a -- ceas -- ta și cu în -- ge -- rii 
  îm -- pre -- u -- nă se bu -- cu -- ră, 
  prea cu -- vi -- oa -- să Mai -- că Pa -- ras -- che -- va,
  du -- hul tău.
}  


sopMusic = \relative c' {
  c4 c f g a f g a b a g g g g f8([ g f e])
  d4( e) f( g) f( e) f2 \bar"|" \breathe
  f4 g a2 a8([ g]) f4 g a b( c)
  b4 a g2 \breathe g4 a b a g f g g a
  g4 f8([ e] d4) e4 f g g f8([ g f e]) d4( e)
  f4( g) f4( e) f2 \breathe
  f4 g a a b( c) b8([ a]) g4 a8([ g a b]) g4.
  f8 b4 a g f e d c2 r4 c f g a2 g4( f)
  g a b( c) b( a) g2 g4 g f8([ e] d4) e f a f g4. \breathe
  f8 g4 a b a c2 g g4 g 
  f8([ g f e]) d4( e) f4( g) f4( e) f2 
  \bar "|."
}

bassMusic = \relative c {
  c2 f f c c1 c2 d d c c f
  f1 f2 c c1 c c c c4 d e f c2
  d d c c f f1 f f2 c c1 c
  c f c c c2 c4 d e f f2 c2
  c c f c1 d c <f f,>2
}  

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \sopMusic }
      %\new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \textOne }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \bassMusic }
      %\addlyrics { \textOne }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
